package de.alexanderlindhorst.jca.ldap;

import org.apache.log4j.*;

import javax.resource.spi.ConnectionRequestInfo;


/**
 * Holds connection specific information
 * @author  $Author: lindhrst $
 * @version $Revision: 1.1.1.1 $
 */
public class LDAPConnectionInfo implements ConnectionRequestInfo,
    LDAPConnectorConstants {
    private static Logger logger = Logger.getLogger(LOG_CATEGORY);
    private String host = null;
    private String principal = null;
    private String credentials = null;

    /** Creates a new instance of LDAPConnectionInfo */
    public LDAPConnectionInfo(String host, String principal, String credentials) {
        this.host = host;
        this.principal = principal;
        this.credentials = credentials;
        logger.debug("LDAPConnectionInfo created: " + toString());
    }

    public String getHost() {
        return host;
    }

    public String getPrincipal() {
        return principal;
    }

    public String getCredentials() {
        return credentials;
    }

    public String toString() {
        return "Host " + host + "; principal: " + principal;
    }

    public boolean equals(Object o) {
        if ((o == null) || !(o instanceof LDAPConnectionInfo)) {
            return false;
        }

        LDAPConnectionInfo other = (LDAPConnectionInfo) o;

        return (this.host == other.host) &&
        (this.principal == other.principal) &&
        (this.credentials == other.credentials);
    }
}
