/*
 * LDAPConnectionFactory.java
 *
 * Created on 9. Januar 2005, 04:17
 */
package de.alexanderlindhorst.jca.ldap;

import org.apache.log4j.*;

import java.io.*;

import javax.naming.*;
import javax.naming.ldap.LdapContext;

import javax.resource.*;
import javax.resource.spi.*;


/**
 * LDAPConnectionFactory is the LDAP connector specific connection
 * factory that provides applications with connections to the
 * underlying LDAP system.
 * @author  $Author: lindhrst $
 * @version $Revision: 1.1.1.1 $
 */
public class LDAPConnectionFactoryImpl implements LDAPConnectionFactory {
    private static Logger logger = Logger.getLogger(LOG_CATEGORY);
    private transient ConnectionManager manager = null;
    private transient ManagedConnectionFactory factory = null;
    private transient javax.naming.Reference reference = null;
    private LDAPConnectionInfo info = null;

    /** Creates a new instance of LDAPConnectionFactory */
    public LDAPConnectionFactoryImpl(ConnectionManager manager,
        ManagedConnectionFactory factory, LDAPConnectionInfo info) {
        this.manager = manager;
        this.factory = factory;
        this.info = info;
        logger.debug(getClass().toString() +
            "- LDAPConnectionFactory created: " + info);
    }

    public javax.naming.Reference getReference()
        throws javax.naming.NamingException {
        return reference;
    }

    public void setReference(javax.naming.Reference reference) {
        this.reference = reference;
        logger.debug(getClass().toString() + "- reference set:  " + reference);
    }

    public javax.naming.ldap.LdapContext getConnection()
        throws NamingException, ResourceException {
        LdapContext ctx = (LdapContext) manager.allocateConnection(factory, info);
        logger.debug(getClass().toString() +
            " - Context/Connection retrieved: " + ctx);

        return ctx;
    }

    public String toString() {
        return getClass().toString() +
        "- LDAPConnectionFactoryImpl instance with " + "Connection Manager: " +
        manager + "; Managed Connection Factory: " + factory + "; Reference: " +
        reference + "; Info: " + info;
    }
}
